/******************************************************************************
                                                 COPYRIGHT (c) FREESCALE 2005   
FILE NAME: per_XEx100_M22E.h                                             
                                                                          
PURPOSE: external declaration of on-chip peripheral variables for HCS12XEP100.                    
         Mask Set: M22E                    
                                                                          
DESCRIPTION:  external declarations for control register blocks of on-chip
              peripherals.
              Include this file in programs that interact with on-chip        
              peripherals.                                                            
                                                                          
UPDATE HISTORY                                                            
REV      AUTHOR      DATE         DESCRIPTION OF CHANGE                    
---      ------      ---------    ---------------------                   
1.0      r32151      13/10/05     Initial coding 
1.1      r32151      26/01/06     xxx0AD0 PIM ports added


      *****************************************************************
      *File created by: Freescale East Kilbride MCD Applications Group*
      *****************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/
                           /*prevent duplicated includes */
#ifndef per_XEx100_M22E_H       
#define per_XEx100_M22E_H


#if (__MWERKS__)
  #pragma MESSAGE DISABLE C1106
#endif
          
#include "S12_COMMON.h"
#include "S12XATD12B16CV1.h"		 /*ATD */
#include "S12MSCANV3.h"				 /*CAN */
#include "S12XECRGV1.h"				 /*CRG */
#include "S12XDBGV3.h"				 /*DBG */
#include "S12XEBIV3.h"				 /*EBI */
#include "S12ECT16B8CV3.h"			 /*ECT */
#include "S12XFTM1024K5V1.h"		 /*FTM */
#include "S12IICV3.h"				 /*IIC */
#include "S12INTV2.h"				 /*INT */
#include "S12XMMCV4.h"				 /*MMC */
#include "S12XMPUV1.h"            /*MPU */
#include "S12XEP512PIMV1.h"		 /*PIM */
#include "S12PIT24B8CV1.h"			 /*PIT */
#include "S12PWM8B8CV1.h"			 /*PWM */
#include "S12SCIV5.h"				 /*SCI */
#include "S12SPIV5.h"				 /*SPI */
#include "S12TIM16B8CV2.h"			 /*TIM */
#include "S12VREGL_3V3V1.h"		 /*VREG */
#include "S12XGATEV3.h"				 /*XGATE */

#include "xgate_channels_M22H.h"

extern volatile tPORT    PORTA    @0x0000;    /* Port A Data Register */
extern volatile tPORT    PORTB    @0x0001;    /* Port B Data Register */
extern volatile tPORT    DDRA     @0x0002;    /* Port A Data Direction Register */
extern volatile tPORT    DDRB     @0x0003;    /* Port B Data Direction Register */
extern volatile tPORT    PORTC    @0x0004;    /* Port C Data Register */
extern volatile tPORT    PORTD    @0x0005;    /* Port D Data Register */
extern volatile tPORT    DDRC     @0x0006;    /* Port C Data Direction Register */
extern volatile tPORT    DDRD     @0x0007;    /* Port D Data Direction Register */
extern volatile tPORT    PORTE    @0x0008;    /* Port E Data Register */
extern volatile tPORT    DDRE     @0x0009;    /* Port E Data Direction Register */

extern volatile tMMCCTL0 MMCCTL0  @0x000A;    /* MMC Control Register 0 - rev 2  */
extern volatile tMODE    MODE     @0x000B;    /* Mode Register => */
extern volatile tPUCR    PUCR     @0x000C;    /* Pull-up Control Register */
extern volatile tRDRIV   RDRIV    @0x000D;    /* Reduced Drive Register */
extern volatile tEBICTL0 EBICTL0  @0x000E;    /* EBI Control Register 0 */
extern volatile tEBICTL1 EBICTL1  @0x000F;    /* EBI Control Register 1 */
extern volatile tGPAGE   GPAGE    @0x0010;    /* Global Page Index Register */
extern volatile tDIRECT  DIRECT   @0x0011;    /* Direct Page Register */
extern volatile tMMCCTL1 MMCCTL1  @0x0013;    /* MMC Control Register 1 */
extern volatile tPPAGE   PPAGE    @0x0015;    /* Program Page Index Register */
extern volatile tRPAGE   RPAGE    @0x0016;    /* RAM Page Index Register */
extern volatile tEPAGE   EPAGE    @0x0017;    /* EEPROM Page Index Register */
extern volatile tREG16   PARTID   @0x001A;    /* Part ID */
extern volatile tECLKCTL ECLKCTL  @0x001C;    /* E-clock Control Register */
extern volatile tIRQCR   IRQCR    @0x001E;    /* IRQ Control Register */
extern volatile tDBG     DBG      @0x0020;    /* DBG module */

extern volatile tPORT    PORTK    @0x0032;    /* Port K Data Register */
extern volatile tPORT    DDRK     @0x0033;    /* Port K Data Direction Register */

extern volatile tCRG     CRG      @0x0034;    /* Clock and Reset Generator Module */

extern volatile tECT     ECT      @0x0040;    /* Enhanced Capture Timer Module */

extern volatile tATD16   ATD1     @0x0080;    /* ATD Module 0 - 16 Channel ATD */

//extern volatile tIIC     IIC0     @0x00B0;    /* IIC Module 0 - use this as a quick check on swapping the modules */
extern volatile tIIC     IIC1     @0x00B0;    /* IIC Module 1 */

extern volatile tSCI     SCI2     @0x00B8;    /* SCI Module 2 */
extern volatile tSCI     SCI3     @0x00C0;    /* SCI Module 3 */
extern volatile tSCI     SCI0     @0x00C8;    /* SCI Module 0 */
extern volatile tSCI     SCI1     @0x00D0;    /* SCI Module 1 */
extern volatile tSPI     SPI0     @0x00D8;    /* SPI Module 0 */

//extern volatile tIIC     IIC1     @0x00E0;    /* IIC Module 1 - use this as a quick check on swapping the modules */
extern volatile tIIC     IIC0     @0x00E0;    /* IIC Module 0 */


extern volatile tSPI     SPI1     @0x00F0;    /* SPI Module 1 */
extern volatile tSPI     SPI2     @0x00F8;    /* SPI Module 2 */

extern volatile tFTM     FTM      @0x0100;    /* NVM Control Registers */

extern volatile tMPU     MPU      @0x0114;    /* MPU Protection Control*/

extern volatile tINT     Interrupt  @0x0120;  /* Interrupt Control Registers */
extern volatile tSCI     SCI4     @0x0130;    /* SCI Module 4 */
extern volatile tSCI     SCI5     @0x0138;    /* SCI Module 5 */
extern volatile tMSCAN   CAN0     @0x0140;    /* MSCAN Module 0 */
extern volatile tMSCAN   CAN1     @0x0180;    /* MSCAN Module 1 */
extern volatile tMSCAN   CAN2     @0x01C0;    /* MSCAN Module 2 */
extern volatile tMSCAN   CAN3     @0x0200;    /* MSCAN Module 3 */

extern volatile tPORT    PTT      @0x0240;    /* PORT T I/O Register */
extern volatile tPORT    PTIT     @0x0241;    /* PORT T Input Register */
extern volatile tPORT    DDRT     @0x0242;    /* PORT T Data Direction Register */
extern volatile tPORT    RDRT     @0x0243;    /* PORT T Reduced Drive Register */
extern volatile tPORT    PERT     @0x0244;    /* PORT T Pull Device Enable Register */
extern volatile tPORT    PPST     @0x0245;    /* PORT T Polarity Select Register */

extern volatile tPORT    PTS      @0x0248;    /* PORT S I/O Register */
extern volatile tPORT    PTIS     @0x0249;    /* PORT S Input Register */
extern volatile tPORT    DDRS     @0x024A;    /* PORT S Data Direction Register */
extern volatile tPORT    RDRS     @0x024B;    /* PORT S Reduced Drive Register */
extern volatile tPORT    PERS     @0x024C;    /* PORT S Pull Device Enable Register */
extern volatile tPORT    PPSS     @0x024D;    /* PORT S Polarity Select Register */
extern volatile tPORT    WOMS     @0x024E;    /* PORT S Wired-Or Mode Register */

extern volatile tPORT    PTM      @0x0250;    /* PORT M I/O Register */
extern volatile tPORT    PTIM     @0x0251;    /* PORT M Input Register */
extern volatile tPORT    DDRM     @0x0252;    /* PORT M Data Direction Register */
extern volatile tPORT    RDRM     @0x0253;    /* PORT M Reduced Drive Register */
extern volatile tPORT    PERM     @0x0254;    /* PORT M Pull Device Enable Register */
extern volatile tPORT    PPSM     @0x0255;    /* PORT M Polarity Select Register */
extern volatile tPORT    WOMM     @0x0256;    /* PORT M Wired-Or Mode Register */
extern volatile tPORT    MODRR    @0x0257;    /* Module Routing Register */

extern volatile tPORT    PTP      @0x0258;    /* PORT P I/O Register */
extern volatile tPORT    PTIP     @0x0259;    /* PORT P Input Register */
extern volatile tPORT    DDRP     @0x025A;    /* PORT P Data Direction Register */
extern volatile tPORT    RDRP     @0x025B;    /* PORT P Reduced Drive Register */
extern volatile tPORT    PERP     @0x025C;    /* PORT P Pull Device Enable Register */
extern volatile tPORT    PPSP     @0x025D;    /* PORT P Polarity Select Register */
extern volatile tPORT    PIEP     @0x025E;    /* PORT P Interrupt Enable Register */
extern volatile tPORT    PIFP     @0x025F;    /* PORT P Interrupt Flag Register */ 

extern volatile tPORT    PTH      @0x0260;    /* PORT H I/O Register */
extern volatile tPORT    PTIH     @0x0261;    /* PORT H Input Register */
extern volatile tPORT    DDRH     @0x0262;    /* PORT H Data Direction Register */
extern volatile tPORT    RDRH     @0x0263;    /* PORT H Reduced Drive Register */
extern volatile tPORT    PERH     @0x0264;    /* PORT H Pull Device Enable Register */
extern volatile tPORT    PPSH     @0x0265;    /* PORT H Polarity Select Register */
extern volatile tPORT    PIEH     @0x0266;    /* PORT H Interrupt Enable Register */
extern volatile tPORT    PIFH     @0x0267;    /* PORT H Interrupt Flag Register */

extern volatile tPORT    PTJ      @0x0268;    /* PORT J I/O Register */
extern volatile tPORT    PTIJ     @0x0269;    /* PORT J Input Register */
extern volatile tPORT    DDRJ     @0x026A;    /* PORT J Data Direction Register */
extern volatile tPORT    RDRJ     @0x026B;    /* PORT J Reduced Drive Register */
extern volatile tPORT    PERJ     @0x026C;    /* PORT J Pull Device Enable Register */
extern volatile tPORT    PPSJ     @0x026D;    /* PORT J Polarity Select Register */
extern volatile tPORT    PIEJ     @0x026E;    /* PORT J Interrupt Enable Register */
extern volatile tPORT    PIFJ     @0x026F;    /* PORT J Interrupt Flag Register */

extern volatile tPORT    PT0AD0   @0x0270;    /* PORT AD0 I/O Register 0 */
extern volatile tPORT    PT1AD0   @0x0271;    /* PORT AD0 I/O Register 1 */
extern volatile tPORT    DDR0AD0  @0x0272;    /* PORT AD0 Data Direction Register 0 */
extern volatile tPORT    DDR1AD0  @0x0273;    /* PORT AD0 Data Direction Register 1 */
extern volatile tPORT    RDR0AD0  @0x0274;    /* PORT AD0 Reduced Drive Register 0 */
extern volatile tPORT    RDR1AD0  @0x0275;    /* PORT AD0 Reduced Drive Register 1 */
extern volatile tPORT    PER0AD0  @0x0276;    /* PORT AD0 Pull-up Enable Register 0 */ 
extern volatile tPORT    PER1AD0  @0x0277;    /* PORT AD0 Pull-up Enable Register 1 */ 

extern volatile tPORT    PT0AD1   @0x0278;    /* PORT AD1 I/O Register 0 */
extern volatile tPORT    PT1AD1   @0x0279;    /* PORT AD1 I/O Register 1 */
extern volatile tPORT    DDR0AD1  @0x027A;    /* PORT AD1 Data Direction Register 0 */
extern volatile tPORT    DDR1AD1  @0x027B;    /* PORT AD1 Data Direction Register 1 */
extern volatile tPORT    RDR0AD1  @0x027C;    /* PORT AD1 Reduced Drive Register 0 */
extern volatile tPORT    RDR1AD1  @0x027D;    /* PORT AD1 Reduced Drive Register 1 */
extern volatile tPORT    PER0AD1  @0x027E;    /* PORT AD1 Pull-up Enable Register 0 */
extern volatile tPORT    PER1AD1  @0x027F;    /* PORT AD1 Pull-up Enable Register 1 */

extern volatile tMSCAN   CAN4     @0x0280;    /* MSCAN Module 4 */
extern volatile tATD16   ATD0     @0x02C0;    /* ATD Module 0 - 16 Channel ATD */
extern volatile tVREG    VREG     @0x02F0;    /* Voltage Regulator */
extern volatile tPWM     PWM      @0x0300;    /* PWM */

extern volatile tSCI     SCI6     @0x0330;    /* SCI Module 6 */
extern volatile tSCI     SCI7     @0x0338;    /* SCI Module 7 */

extern volatile tPIT     PIT      @0x0340;    /* PIT */

extern volatile tPORT    PTR      @0x0368;    /* PORT R I/O Register */
extern volatile tPORT    PTIR     @0x0369;    /* PORT R Input Register */
extern volatile tPORT    DDRR     @0x036A;    /* PORT R Data Direction Register */
extern volatile tPORT    RDRR     @0x036B;    /* PORT R Reduced Drive Register */
extern volatile tPORT    PERR     @0x036C;    /* PORT R Pull Device Enable Register */
extern volatile tPORT    PPSR     @0x036D;    /* PORT R Polarity Select Register */
extern volatile tPORT    PTRRR    @0x036F;    /* PORT R Module Routing Register */

extern volatile tPORT    PTL      @0x0370;    /* PORT L I/O Register */
extern volatile tPORT    PTIL     @0x0371;    /* PORT L Input Register */
extern volatile tPORT    DDRL     @0x0372;    /* PORT L Data Direction Register */
extern volatile tPORT    RDRL     @0x0373;    /* PORT L Reduced Drive Register */
extern volatile tPORT    PERL     @0x0374;    /* PORT L Pull Device Enable Register */
extern volatile tPORT    PPSL     @0x0375;    /* PORT L Polarity Select Register */
extern volatile tPORT    WOML     @0x0376;    /* PORT L Wired-Or Mode Register */
extern volatile tPORT    PTLRR    @0x0377;    /* PORT L Module Routing Register */

extern volatile tPORT    PTF      @0x0378;    /* PORT F I/O Register */
extern volatile tPORT    PTIF     @0x0379;    /* PORT F Input Register */
extern volatile tPORT    DDRF     @0x037A;    /* PORT F Data Direction Register */
extern volatile tPORT    RDRF     @0x037B;    /* PORT F Reduced Drive Register */
extern volatile tPORT    PERF     @0x037C;    /* PORT F Pull Device Enable Register */
extern volatile tPORT    PPSF     @0x037D;    /* PORT F Polarity Select Register */
extern volatile tPORT    PTFRR    @0x037F;    /* PORT F Module Routing Register */

extern volatile tXGATE   XGATE    @0x0380;    /* XGATE Module */
extern volatile tTIMER   Timer    @0x03D0;    /* Enhanced Capture Timer Module */



#endif /* per_XEx100_M22E_H */
